/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing.component;

import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.ProgressWindowTask;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class ProgressWindow
extends JDialog
implements ActionListener {
    private final ProgressWindowTask<?> taskToExecute;
    private final Map<String, String> messages;
    private final boolean rightToLeft;
    private final Component mainWindow;
    private JButton cancelButton;

    public ProgressWindow(ProgressWindowTask<?> taskToExecute, Language language, boolean rightToLeft, Component parent) {
        this.taskToExecute = taskToExecute;
        this.messages = LanguageDisplayFactory.getDisplayMessages(this.getClass(), language);
        this.rightToLeft = rightToLeft;
        this.mainWindow = parent;
    }

    public void showProgress() {
        this.drawComponents();
        new Task().execute();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.cancelButton) {
            this.cancelButton.setEnabled(false);
            this.taskToExecute.interrupt();
        }
    }

    private void drawComponents() {
        this.setBounds(100, 100, 288, 138);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        this.setUndecorated(true);
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder(Color.BLACK, Color.GRAY));
        this.setContentPane(panel);
        this.setLocationRelativeTo(this.mainWindow);
        if (this.rightToLeft) {
            this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        JLabel lblNewLabel = new JLabel(this.messages.get("SCANNING") + "...");
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        this.cancelButton = new JButton(this.messages.get("CANCEL"));
        this.cancelButton.addActionListener(this);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(25).addComponent(lblNewLabel)).addGroup(groupLayout.createSequentialGroup().addGap(25).addComponent(progressBar, -2, 238, -2)).addGroup(groupLayout.createSequentialGroup().addGap(92).addComponent(this.cancelButton, -2, 92, -2)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(20).addComponent(lblNewLabel).addGap(11).addComponent(progressBar, -2, 21, -2).addGap(18).addComponent(this.cancelButton)));
        this.getContentPane().setLayout(groupLayout);
    }

    private class Task
    extends SwingWorker<Void, Void> {
        private Task() {
        }

        @Override
        public Void doInBackground() {
            ProgressWindow.this.taskToExecute.execute();
            return null;
        }

        @Override
        public void done() {
            ProgressWindow.this.dispose();
        }
    }
}

